<#ibiztemplate>
TARGET=PSAPPVIEWMSG
</#ibiztemplate>
import ViewMessageService from '../view-message-service';
/**
 * ${item.getName()}视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ${item.getCodeName()}MessageServiceBase
 */
export default class ${srfclassname('${item.getCodeName()}')}MessageServiceBase extends ViewMessageService {

<#-- 动态模式为实体数据集合start -->
<#if item.getDynamicMode() == 1>
    /**
     * 支持缓存
     *
     * @type {boolean}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public isEnableCache:boolean = ${item.isEnableCache()?c};

    /**
     * 缓存范围
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public cacheScope:string = "${item.getCacheScope()}";

    /**
     * 缓存超时
     *
     * @type {number}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public cacheTimeout:number = ${item.getCacheTimeout()?c};

    /**
     * 过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public static expirationTime:any;

    /**
     * 获取过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public getExpirationTime(){
        return ${srfclassname('${item.getCodeName()}')}MessageServiceBase.expirationTime;
    }

    /**
     * 设置过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public setExpirationTime(value:any){
        ${srfclassname('${item.getCodeName()}')}MessageServiceBase.expirationTime = value; 
    }

    /**
     * 应用实体对象名
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */  
    public appDataEntityName:string = "<#if item.getPSAppDataEntity()??>${item.getPSAppDataEntity().getCodeName()}</#if>";

    /**
     * 实体数据集合接口名
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */  
    public appDataSetName:string = "<#if item.getPSAppDEDataSet()??>${item.getPSAppDEDataSet().getCodeName()}</#if>";
</#if>
<#-- 动态模式为实体数据集合end -->

    /**
     * Creates an instance of  ${srfclassname('${item.getCodeName()}')}MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public initBasicParam(){
        this.id = "${item.getId()}";
        this.name = "${item.getName()}";
        this.codename = "<#if item.getCodeName()??>${item.getCodeName()}</#if>";
        this.title = "<#if item.getTitle()??>${item.getTitle()}</#if>";
        this.content = "<#if item.getMessage()??>${item.getMessage()}</#if>";
        this.closeMode = ${item.getRemoveMode()?c};
        this.position = "<#if item.getPosition() !="">${item.getPosition()}<#else>TOP</#if>";
        this.type = "<#if item.getMessageType() !=""><#if item.getMessageType() =="WARN">warning<#else>${item.getMessageType()?lower_case}</#if><#else>info</#if>";
        this.isEnableRemove = ${item.isEnableRemove()?c};
        this.order = 1;
        this.dynamicMode = "<#if item.getDynamicMode() == 0>STATIC<#else>DYNAMIC</#if>";
        this.hasMessageTemp = <#if item.getPSSysMsgTempl()??>true<#else>false</#if>;
        this.messageType = "<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getContentType()??>${item.getPSSysMsgTempl().getContentType()}<#else>TEXT</#if>";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:`<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getSubject()??>${item.getPSSysMsgTempl().getSubject()}</#if>`});
            Object.assign(target,{content:`<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getContent()??>${item.getPSSysMsgTempl().getContent()}</#if>`});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:"<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getSubject()??>${item.getPSSysMsgTempl().getSubject()}</#if>"});
            Object.assign(target,{content:"<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getContent()??>${item.getPSSysMsgTempl().getContent()}</#if>"});
        }
    }

<#-- 动态模式为实体数据集合start -->
<#if item.getDynamicMode() == 1>
    /**
     * 获取远程数据
     *
     * @param {*} context 应用上下文
     * @param {*} data 视图参数
     * @param {boolean} [isloading] 加载状态
     * @returns {Promise<any>}
     *
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public getItems(context: any={}, data: any={}, isloading?: boolean): Promise<any> {
        let tempContext:any = context?context:{};
        let tempData:any = data?data:{};
        return new Promise((resolve, reject) => {
            this.entityService.getService(this.appDataEntityName.toLowerCase()).then((service:any) =>{
                if(service[this.appDataSetName] && service[this.appDataSetName] instanceof Function){
                    const promise: Promise<any> = service[this.appDataSetName](tempContext, tempData, isloading);
                    promise.then((response: any) => {
                        if (response && response.status === 200) {
                            const data =  response.data;
                            resolve(this.doItems(data,tempContext,tempData));
                        } else {
                            resolve([]);
                        }
                    }).catch((response: any) => {
                        console.error(response);
                        reject(response);
                    });
                }
            })
        });
    }

    /**
     * 处理数据
     *
     * @param {any[]} items 源数据
     * @param {*} context 应用上下文
     * @param {*} data 视图参数
     * @returns {any[]}
     *
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public doItems(items: any[],context:any,viewparam:any): any[] {
        let _items: any[] = [];
        items.forEach((item: any) => {
            let itemdata:any = {
                id:"${item.getId()}",
                name:"${item.getName()}",
                codename:"<#if item.getCodeName()??>${item.getCodeName()}</#if>",
                title:<#if item.getTitlePSDEField()??>item['${item.getTitlePSDEField().getCodeName()?lower_case}']<#else>"<#if item.getTitle()??>${item.getTitle()}</#if>"</#if>,
                content:<#if item.getContentPSDEField()??>item['${item.getContentPSDEField().getCodeName()?lower_case}']<#else>"<#if item.getMessage()??>${item.getMessage()}</#if>"</#if>,
                closeMode:${item.getRemoveMode()?c},
                position:<#if item.getMsgPosPSDEField()??>item['${item.getMsgPosPSDEField().getCodeName()?lower_case}']<#else>"<#if item.getPosition() !="">${item.getPosition()}<#else>TOP</#if>"</#if>,
                type:<#if item.getMsgTypePSDEField()??>item['${item.getMsgTypePSDEField().getCodeName()?lower_case}']<#else>"<#if item.getMessageType() !=""><#if item.getMessageType() =="WARN">warning<#else>${item.getMessageType()?lower_case}</#if><#else>info</#if>"</#if>,
                isEnableRemove:<#if item.getRemoveFlagPSDEField()??>item['${item.getRemoveFlagPSDEField().getCodeName()?lower_case}']<#else>${item.isEnableRemove()?c}</#if>,
                order:<#if item.getOrderValuePSDEField()??>item['${item.getOrderValuePSDEField().getCodeName()?lower_case}']<#else>1</#if>,
                dynamicMode:"DYNAMIC",
                messageType:"<#if item.getPSSysMsgTempl()?? && item.getPSSysMsgTempl().getContentType()??>${item.getPSSysMsgTempl().getContentType()}<#else>TEXT</#if>"
            };
            this.translateMessageTemp(itemdata,context,viewparam,item);
            _items.push(itemdata);
        });
        return _items;
    }
</#if>
<#-- 动态模式为实体数据集合end -->
}